<?php
/*
 * Plugin Name: Modal Portfolio
 * Plugin URI: http://www.internet-formation.fr
 * Description: Portfolio avec photos, description, titre et filtres en responsive avec de multiples options (responsive portfolio with images, description, title and filters (with multiple settings)
 * Version: 1.7.4.2
 * Author: Mathieu Chartier
 * Author URI: http://www.mathieu-chartier.com
 * Text Domain: modal-portfolio
 * Domain Path: /languages
*/
// Version du plugin
global $modal_portfolio_version;
$modal_portfolio_version = "1.7.4.2";

// Gestion des langues
function modal_portfolio_lang() {
	$path = dirname(plugin_basename(__FILE__)).'/languages/';
	load_plugin_textdomain('modal-portfolio', NULL, $path);
}
add_action('plugins_loaded', 'modal_portfolio_lang');

// Fonction lancée lors de l'activation ou de la desactivation de l'extension
register_activation_hook( __FILE__, 'modal_portfolio_installation');
register_deactivation_hook( __FILE__, 'modal_portfolio_desinstallation');

// Message de sécurité lors de la mise à jour du plugin (compatible multisites)
function prefix_plugin_update_message($data, $response) {
	if(isset($plugin_data['update']) && $plugin_data['update'] && isset($new_data->upgrade_notice)) {
		printf(
			'<div class="update-message"><p><strong>%s</strong> : %s</p></div>',
			$new_data->new_version,
			wpautop($new_data->upgrade_notice)
		);
	}
}
add_action('in_plugin_update_message-modal-portfolio/modal-portfolio.php', 'prefix_plugin_update_message', 10, 2);
// function prefix_ms_plugin_update_message( $file, $plugin ) {
// 	if(is_multisite() && version_compare($plugin['Version'], $plugin['new_version'], '<')) {
// 		$wp_list_table = _get_list_table('WP_Plugins_List_Table');
// 		printf(
// 			'<tr class="plugin-update-tr"><td colspan="%s" class="plugin-update update-message notice inline notice-warning notice-alt"><div class="update-message"><h4 style="margin: 0; font-size: 14px;">%s</h4>%s</div></td></tr>',
// 			$wp_list_table->get_column_count(),
// 			$plugin['Name'],
// 			wpautop($plugin['upgrade_notice'])
// 		);
// 	}
// }
// add_action('after_plugin_row_wp-modal-portfolio/modal-portfolio.php', 'prefix_ms_plugin_update_message', 10, 2);

// Réglages par défaut (enregistrement des options)
function modal_portfolio_installation() {
	global $modal_portfolio_version;

	// Valeurs par défaut
	add_site_option("modal_portfolio_filters", true);
	add_site_option("modal_portfolio_allFilter", true);
	add_site_option("modal_portfolio_text_modal", true);
	add_site_option("modal_portfolio_title_modal", true);
	add_site_option("modal_portfolio_title_thumbnail", true);
	add_site_option("modal_portfolio_thumbnail_default", true);
	add_site_option("modal_portfolio_close_button", true);
	add_site_option("modal_portfolio_max_display", 0);
	add_site_option("modal_portfolio_order_images", "DESC");
	add_site_option("modal_portfolio_orderby_images", "date");
	add_site_option("modal_portfolio_order_filters", "ASC");
	add_site_option("modal_portfolio_orderby_filters", "title");
	add_site_option("modal_portfolio_modalOpacity", 70);
	add_site_option("modal_portfolio_overlayCloseClick", true);
	add_site_option("modal_portfolio_colorOverlay", "#666666");
	add_site_option("modal_portfolio_overlayDuration", 200);
	add_site_option("modal_portfolio_hideShowDuration", 400);
	add_site_option("modal_portfolio_openEffect", "fadeIn");
	add_site_option("modal_portfolio_thumbnailsEffect", "hover");
	add_site_option("modal_portfolio_openUpEffect", "easeOutQuad");
	add_site_option("modal_portfolio_openDownEffect", "easeInQuad");
	add_site_option("modal_portfolio_openUpDuration", 600);
	add_site_option("modal_portfolio_openDownDuration", 300);
	add_site_option("modal_portfolio_css_path", plugins_url().'/modal-portfolio/css/portfolio.css');
	add_site_option("modal_portfolio_styleType", 0);
	add_site_option("modal_portfolio_effectsSource", "bottom");
	add_site_option("modal_portfolio_effectsHeight", "45");
	add_site_option("modal_portfolio_colorOverall", "#FFFFFF");
	add_site_option("modal_portfolio_bgcolorOverall", "#242424");
	add_site_option("modal_portfolio_effectsPadding", "5");
	add_site_option("modal_portfolio_effectsAlign", "left");
	add_site_option("modal_portfolio_bgcolorModal", "#FFFFFF");
	add_site_option("modal_portfolio_borderWidthModal", "2");
	add_site_option("modal_portfolio_borderStyleModal", "solid");
	add_site_option("modal_portfolio_borderColorModal", "#666666");
	add_site_option("modal_portfolio_cornersTypeModal", true);
	add_site_option("modal_portfolio_cornersRadiusModal", "5px 5px 5px 5px");
	add_site_option("modal_portfolio_widthThumbnails", "31%");
	add_site_option("modal_portfolio_marginThumbnails", "1%");
	add_site_option("modal_portfolio_widthModal", "60%");
	add_site_option("modal_portfolio_heightModal", "auto");
	add_site_option("modal_portfolio_widthModalCol1", "44%");
	add_site_option("modal_portfolio_widthModalCol2", "54%");
	add_site_option("modal_portfolio_marginRightModalCol1", "2%");
	add_site_option("modal_portfolio_fontSizeFilter", ".9em");
	add_site_option("modal_portfolio_bgcolorLinkFilter", "#242424");
	add_site_option("modal_portfolio_bgcolorHoverFilter", "#FFFFFF");
	add_site_option("modal_portfolio_colorLinkFilter", "#FFFFFF");
	add_site_option("modal_portfolio_colorHoverFilter", "#242424");
	add_site_option("modal_portfolio_borderWidth", "1");
	add_site_option("modal_portfolio_borderStyle", "solid");
	add_site_option("modal_portfolio_borderColor", "#242424");
	add_site_option("modal_portfolio_cornersTypeFilter", true);
	add_site_option("modal_portfolio_cornersRadiusFilter", "5px 5px 5px 5px");
	add_site_option("modal_portfolio_paddingFilter", ".3em 1em");
	add_site_option("modal_portfolio_marginFilter", ".3em .3em");
	
	// Prise en compte de la version en cours
	add_site_option("modal_portfolio_version", $modal_portfolio_version);
}

// Quand l'extension est désactivée, les options sont supprimées...
function modal_portfolio_desinstallation() {
	// Suppression des options
	delete_site_option("modal_portfolio_filters");
	delete_site_option("modal_portfolio_allFilter");
	delete_site_option("modal_portfolio_text_modal");
	delete_site_option("modal_portfolio_title_modal");
	delete_site_option("modal_portfolio_title_thumbnail");
	delete_site_option("modal_portfolio_thumbnail_default");
	delete_site_option("modal_portfolio_close_button");
	delete_site_option("modal_portfolio_max_display");
	delete_site_option("modal_portfolio_order_images");
	delete_site_option("modal_portfolio_orderby_images");
	delete_site_option("modal_portfolio_order_filters");
	delete_site_option("modal_portfolio_orderby_filters");
	delete_site_option("modal_portfolio_modalOpacity");
	delete_site_option("modal_portfolio_overlayCloseClick");
	delete_site_option("modal_portfolio_colorOverlay");
	delete_site_option("modal_portfolio_overlayDuration");
	delete_site_option("modal_portfolio_hideShowDuration");
	delete_site_option("modal_portfolio_openEffect");
	delete_site_option("modal_portfolio_thumbnailsEffect");
	delete_site_option("modal_portfolio_openUpEffect");
	delete_site_option("modal_portfolio_openDownEffect");
	delete_site_option("modal_portfolio_openUpDuration");
	delete_site_option("modal_portfolio_openDownDuration");
	delete_site_option("modal_portfolio_css_path");
	delete_site_option("modal_portfolio_styleType");
	delete_site_option("modal_portfolio_effectsSource");
	delete_site_option("modal_portfolio_effectsHeight");
	delete_site_option("modal_portfolio_colorOverall");
	delete_site_option("modal_portfolio_bgcolorOverall");
	delete_site_option("modal_portfolio_effectsPadding");
	delete_site_option("modal_portfolio_effectsAlign");
	delete_site_option("modal_portfolio_bgcolorModal");
	delete_site_option("modal_portfolio_borderWidthModal");
	delete_site_option("modal_portfolio_borderStyleModal");
	delete_site_option("modal_portfolio_borderColorModal");
	delete_site_option("modal_portfolio_cornersTypeModal");
	delete_site_option("modal_portfolio_cornersRadiusModal");
	delete_site_option("modal_portfolio_widthThumbnails");
	delete_site_option("modal_portfolio_marginThumbnails");
	delete_site_option("modal_portfolio_widthModal");
	delete_site_option("modal_portfolio_heightModal");
	delete_site_option("modal_portfolio_widthModalCol1");
	delete_site_option("modal_portfolio_widthModalCol2");
	delete_site_option("modal_portfolio_marginRightModalCol1");
	delete_site_option("modal_portfolio_fontSizeFilter");
	delete_site_option("modal_portfolio_bgcolorLinkFilter");
	delete_site_option("modal_portfolio_bgcolorHoverFilter");
	delete_site_option("modal_portfolio_colorLinkFilter");
	delete_site_option("modal_portfolio_colorHoverFilter");
	delete_site_option("modal_portfolio_borderWidth");
	delete_site_option("modal_portfolio_borderStyle");
	delete_site_option("modal_portfolio_borderColor");
	delete_site_option("modal_portfolio_cornersTypeFilter");
	delete_site_option("modal_portfolio_cornersRadiusFilter");
	delete_site_option("modal_portfolio_paddingFilter");
	delete_site_option("modal_portfolio_marginFilter");
	
	// Suppression de la version du plugin
	delete_site_option("modal_portfolio_version");
}

// Quand le plugin est mise à jour, on relance la fonction
function modal_portfolio_upgrade() {
	// Mise à jour du nom des catégories
	global $wpdb;
	// $wpdb->update(
	// 	$wpdb->prefix."term_taxonomy", 
	// 	array('taxonomy' => 'modal-portfolio-cats'), 
	// 	array('taxonomy' => 'project-cat')
	// );

	global $modal_portfolio_version;
	if(get_site_option('modal_portfolio_version') != $modal_portfolio_version) {
		// Nouvelles données v1.3
		if(!get_site_option('modal_portfolio_styleType')) {
			update_site_option("modal_portfolio_styleType", 0);
			update_site_option("modal_portfolio_effectsSource", "bottom");
			update_site_option("modal_portfolio_effectsHeight", "45");
			update_site_option("modal_portfolio_colorOverall", "#FFFFFF");
			update_site_option("modal_portfolio_bgcolorOverall", "#242424");
			update_site_option("modal_portfolio_effectsPadding", "5");
			update_site_option("modal_portfolio_effectsAlign", "left");
			update_site_option("modal_portfolio_cornersTypeModal", true);
			update_site_option("modal_portfolio_cornersRadiusModal", "5px 5px 5px 5px");
			update_site_option("modal_portfolio_widthThumbnails", "31%");
			update_site_option("modal_portfolio_marginThumbnails", "1%");
			update_site_option("modal_portfolio_bgcolorLinkFilter", "#242424");
			update_site_option("modal_portfolio_bgcolorHoverFilter", "#FFFFFF");
			update_site_option("modal_portfolio_colorLinkFilter", "#FFFFFF");
			update_site_option("modal_portfolio_colorHoverFilter", "#242424");
			update_site_option("modal_portfolio_borderWidth", "1");
			update_site_option("modal_portfolio_borderStyle", "solid");
			update_site_option("modal_portfolio_borderColor", "#242424");
			update_site_option("modal_portfolio_cornersTypeFilter", true);
			update_site_option("modal_portfolio_cornersRadiusFilter", "5px 5px 5px 5px");
			update_site_option("modal_portfolio_marginFilter", ".3em .3em");
		}
		// Nouvelles données v1.4
		if(!get_site_option('modal_portfolio_widthModal')) {
			update_site_option("modal_portfolio_widthModal", "60%");
			update_site_option("modal_portfolio_heightModal", "auto");
			update_site_option("modal_portfolio_widthModalCol1", "44%");
			update_site_option("modal_portfolio_widthModalCol2", "54%");
			update_site_option("modal_portfolio_marginRightModalCol1", "2%");
		}
		// Nouvelles données v1.5
		if(!get_site_option('modal_portfolio_widthModal')) {
			update_site_option("modal_portfolio_thumbnail_default", true);
		}
		// Nouvelles données v1.6
		if(!get_site_option('modal_portfolio_fontSizeFilter')) {
			update_site_option("modal_portfolio_fontSizeFilter", ".9em");
			update_site_option("modal_portfolio_paddingFilter", ".3em 1em");
		}
		// Nouvelles données v1.7
		if(!get_site_option('modal_portfolio_max_display')) {
			update_site_option("modal_portfolio_max_display", 0);
			update_site_option("modal_portfolio_order_images", "DESC");
			update_site_option("modal_portfolio_orderby_images", "date");
			update_site_option("modal_portfolio_order_filters", "ASC");
			update_site_option("modal_portfolio_orderby_filters", "title");
		}
		// Nouvelles données 1.7.2+
		if(!get_site_option('modal_portfolio_bgcolorModal')) {
			if(get_site_option("modal_portfolio_thumbnailsEffect") == true) {
				update_site_option("modal_portfolio_thumbnailsEffect", "hover");
			} else {
				update_site_option("modal_portfolio_thumbnailsEffect", "none");
			}
			update_site_option("modal_portfolio_bgcolorModal", "#FFFFFF");
			update_site_option("modal_portfolio_borderWidthModal", "2");
			update_site_option("modal_portfolio_borderStyleModal", "solid");
			update_site_option("modal_portfolio_borderColorModal", "#666666");
		}
		// Mise à jour 1.7.4 (changement du post-type "portfolio" par "modal-portfolio-item")
		if(!post_type_exists('modal-portfolio-item')) {
			$portfolio_items = get_posts(array(
				'posts_per_page' => -1,
				'post_type' => 'portfolio', // Ancien post type à modifier
			));
			foreach($portfolio_items as $pf_item) {
				set_post_type($pf_item->ID, 'modal-portfolio-item'); // Déclaration du nouveau post-type
			}

			// $old_post_types = array('portfolio' => 'modal-portfolio-item');
			// foreach($old_post_types as $old_type=>$type) {
			// 	$wpdb->query( $wpdb->prepare( "UPDATE {$wpdb->posts} SET post_type = REPLACE(post_type, %s, %s) 
			// 						 WHERE post_type LIKE %s", $old_type, $type, $old_type ) );
			// 	$wpdb->query( $wpdb->prepare( "UPDATE {$wpdb->posts} SET guid = REPLACE(guid, %s, %s) 
			// 						 WHERE guid LIKE %s", "post_type={$old_type}", "post_type={$type}", "%post_type={$old_type}%" ) );
			// 	$wpdb->query( $wpdb->prepare( "UPDATE {$wpdb->posts} SET guid = REPLACE(guid, %s, %s) 
			// 						 WHERE guid LIKE %s", "/{$old_type}/", "/{$type}/", "%/{$old_type}/%" ) );
			// }
		}

		// Mise à jour de la version du plugin en cours
		update_site_option("modal_portfolio_version", $modal_portfolio_version);
	}
}
add_action('plugins_loaded', 'modal_portfolio_upgrade');

// Inclusion des menus personnalisés
include('inc/modal-portfolio-menus.php');

// Inclusion de la metabox supplémentaire (titre de la vignette)
include('inc/modal-portfolio-metaboxes.php');

// Inclusion du shortcode
include('inc/modal-portfolio-shortcode.php');

// Activation des images à la Une pour le portfolio (obligatoire !)
add_theme_support('post-thumbnails', array('modal-portfolio-item'));
// add_theme_support('post-thumbnails', array('portfolio'));

// Liste des scripts et CSS utiles
function modal_portfolio_scripts() {
	wp_enqueue_script('isotope-mpf', plugins_url().'/modal-portfolio/js/isotope.min.js', array('jquery'), '3.0.4', true);
	wp_enqueue_script('image-loaded-mpf', plugins_url().'/modal-portfolio/js/imagesloaded.min.js', array('jquery'), '4.1.2', true);
	wp_enqueue_script('simplemodal-mpf', plugins_url().'/modal-portfolio/js/jquery.simplemodal.1.4.4.min.js', array('jquery'), '1.4.4', true);
	wp_enqueue_script("jquery-effects-core");
	
	// Variables passées au fichier portfolio.js
	$params = array(
		'modalOpacity'		=> get_site_option("modal_portfolio_modalOpacity"),
		'overlayCloseClick'	=> get_site_option("modal_portfolio_overlayCloseClick"),
		'colorOverlay'		=> get_site_option("modal_portfolio_colorOverlay"),
		'overlayDuration'	=> get_site_option("modal_portfolio_overlayDuration"),
		'hideShowDuration'	=> get_site_option("modal_portfolio_hideShowDuration"),
		'openEffect'		=> get_site_option("modal_portfolio_openEffect"),
		'thumbnailsEffect'	=> get_site_option("modal_portfolio_thumbnailsEffect"),
		'openUpEffect'		=> get_site_option("modal_portfolio_openUpEffect"),
		'openDownEffect'	=> get_site_option("modal_portfolio_openDownEffect"),
		'openUpDuration'	=> get_site_option("modal_portfolio_openUpDuration"),
		'openDownDuration'	=> get_site_option("modal_portfolio_openDownDuration"),
		'activeDynamicCSS'	=> get_site_option("modal_portfolio_styleType"),
		'positionEffect'	=> get_site_option("modal_portfolio_effectsSource"),
		'heightEffect'		=> get_site_option("modal_portfolio_effectsHeight"),
	);
	wp_enqueue_script('portfolio-script-mpf', plugins_url('/modal-portfolio/js/portfolio.min.js', dirname(__FILE__)), array('jquery'), '1.0', true);
	wp_localize_script('portfolio-script-mpf', 'parametres', $params);
	
	// Ajout de la feuille de style désirée !
	if(get_site_option('modal_portfolio_css_path') == plugins_url().'/modal-portfolio/css/portfolio.php' || get_site_option('modal_portfolio_css_path') == plugins_url().'/modal-portfolio/css/portfolio.css') {
		if(get_site_option('modal_portfolio_styleType') == 1) {
			wp_enqueue_style('modal-portfolio', plugins_url().'/modal-portfolio/css/portfolio.php');
		} else {
			wp_enqueue_style('modal-portfolio', plugins_url().'/modal-portfolio/css/portfolio.css');
		}
	} elseif(trim(get_site_option('modal_portfolio_css_path')) != '') {
		wp_enqueue_style('modal-portfolio', get_site_option('modal_portfolio_css_path'));
	}
}
add_action('wp_enqueue_scripts', 'modal_portfolio_scripts');

// Ajout d'une feuille de style pour l'admin
function modal_portfolio_admin_scripts_CSS() {
	// Style côté backoffice
	$style	= plugins_url('css/modal-portfolio-admin.css', __FILE__);
	wp_enqueue_style('modal-portfolio-admin', $style, 15);
	
	// Style du slider range
	wp_enqueue_style("range-style", plugins_url('css/jquery-ui.css', __FILE__));
	
	// Ajout des scripts utiles pour le plugin
	wp_enqueue_script('iris-colorpicker-script-mpf', plugins_url('/js/iris.min.js', __FILE__), array('jquery', 'jquery-ui'), false, true);
	wp_enqueue_script('colorpicker-script-mpf', plugins_url('/js/colorpicker-script.js', __FILE__), array('wp-color-picker'), false, true);
	wp_enqueue_script('jquery-ui-slider');
}
add_action('admin_enqueue_scripts', 'modal_portfolio_admin_scripts_CSS');
?>